<?php
/**
 * UnfulfillableQuantity
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  SellingPartnerApi
 */

/**
 * Selling Partner API for FBA Inventory
 *
 * The Selling Partner API for FBA Inventory lets you programmatically retrieve information about inventory in Amazon's fulfillment network.
 *
 * The version of the OpenAPI document: v1
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SellingPartnerApi\Model\FbaInventoryV1;
use ArrayAccess;
use SellingPartnerApi\Model\BaseModel;
use SellingPartnerApi\Model\ModelInterface;
use SellingPartnerApi\ObjectSerializer;

/**
 * UnfulfillableQuantity Class Doc Comment
 *
 * @category Class
 * @description The quantity of unfulfillable inventory.
 * @package  SellingPartnerApi
 * @group 
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class UnfulfillableQuantity extends BaseModel implements ModelInterface, ArrayAccess, \JsonSerializable, \IteratorAggregate
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'UnfulfillableQuantity';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'total_unfulfillable_quantity' => 'int',
        'customer_damaged_quantity' => 'int',
        'warehouse_damaged_quantity' => 'int',
        'distributor_damaged_quantity' => 'int',
        'carrier_damaged_quantity' => 'int',
        'defective_quantity' => 'int',
        'expired_quantity' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'total_unfulfillable_quantity' => null,
        'customer_damaged_quantity' => null,
        'warehouse_damaged_quantity' => null,
        'distributor_damaged_quantity' => null,
        'carrier_damaged_quantity' => null,
        'defective_quantity' => null,
        'expired_quantity' => null
    ];



    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'total_unfulfillable_quantity' => 'totalUnfulfillableQuantity',
        'customer_damaged_quantity' => 'customerDamagedQuantity',
        'warehouse_damaged_quantity' => 'warehouseDamagedQuantity',
        'distributor_damaged_quantity' => 'distributorDamagedQuantity',
        'carrier_damaged_quantity' => 'carrierDamagedQuantity',
        'defective_quantity' => 'defectiveQuantity',
        'expired_quantity' => 'expiredQuantity'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
                'total_unfulfillable_quantity' => 'setTotalUnfulfillableQuantity',
        'customer_damaged_quantity' => 'setCustomerDamagedQuantity',
        'warehouse_damaged_quantity' => 'setWarehouseDamagedQuantity',
        'distributor_damaged_quantity' => 'setDistributorDamagedQuantity',
        'carrier_damaged_quantity' => 'setCarrierDamagedQuantity',
        'defective_quantity' => 'setDefectiveQuantity',
        'expired_quantity' => 'setExpiredQuantity'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'total_unfulfillable_quantity' => 'getTotalUnfulfillableQuantity',
        'customer_damaged_quantity' => 'getCustomerDamagedQuantity',
        'warehouse_damaged_quantity' => 'getWarehouseDamagedQuantity',
        'distributor_damaged_quantity' => 'getDistributorDamagedQuantity',
        'carrier_damaged_quantity' => 'getCarrierDamagedQuantity',
        'defective_quantity' => 'getDefectiveQuantity',
        'expired_quantity' => 'getExpiredQuantity'
    ];


    
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['total_unfulfillable_quantity'] = $data['total_unfulfillable_quantity'] ?? null;
        $this->container['customer_damaged_quantity'] = $data['customer_damaged_quantity'] ?? null;
        $this->container['warehouse_damaged_quantity'] = $data['warehouse_damaged_quantity'] ?? null;
        $this->container['distributor_damaged_quantity'] = $data['distributor_damaged_quantity'] ?? null;
        $this->container['carrier_damaged_quantity'] = $data['carrier_damaged_quantity'] ?? null;
        $this->container['defective_quantity'] = $data['defective_quantity'] ?? null;
        $this->container['expired_quantity'] = $data['expired_quantity'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];
        return $invalidProperties;
    }


    /**
     * Gets total_unfulfillable_quantity
     *
     * @return int|null
     */
    public function getTotalUnfulfillableQuantity()
    {
        return $this->container['total_unfulfillable_quantity'];
    }

    /**
     * Sets total_unfulfillable_quantity
     *
     * @param int|null $total_unfulfillable_quantity The total number of units in Amazon's fulfillment network in unsellable condition.
     *
     * @return self
     */
    public function setTotalUnfulfillableQuantity($total_unfulfillable_quantity)
    {
        $this->container['total_unfulfillable_quantity'] = $total_unfulfillable_quantity;

        return $this;
    }
    /**
     * Gets customer_damaged_quantity
     *
     * @return int|null
     */
    public function getCustomerDamagedQuantity()
    {
        return $this->container['customer_damaged_quantity'];
    }

    /**
     * Sets customer_damaged_quantity
     *
     * @param int|null $customer_damaged_quantity The number of units in customer damaged disposition.
     *
     * @return self
     */
    public function setCustomerDamagedQuantity($customer_damaged_quantity)
    {
        $this->container['customer_damaged_quantity'] = $customer_damaged_quantity;

        return $this;
    }
    /**
     * Gets warehouse_damaged_quantity
     *
     * @return int|null
     */
    public function getWarehouseDamagedQuantity()
    {
        return $this->container['warehouse_damaged_quantity'];
    }

    /**
     * Sets warehouse_damaged_quantity
     *
     * @param int|null $warehouse_damaged_quantity The number of units in warehouse damaged disposition.
     *
     * @return self
     */
    public function setWarehouseDamagedQuantity($warehouse_damaged_quantity)
    {
        $this->container['warehouse_damaged_quantity'] = $warehouse_damaged_quantity;

        return $this;
    }
    /**
     * Gets distributor_damaged_quantity
     *
     * @return int|null
     */
    public function getDistributorDamagedQuantity()
    {
        return $this->container['distributor_damaged_quantity'];
    }

    /**
     * Sets distributor_damaged_quantity
     *
     * @param int|null $distributor_damaged_quantity The number of units in distributor damaged disposition.
     *
     * @return self
     */
    public function setDistributorDamagedQuantity($distributor_damaged_quantity)
    {
        $this->container['distributor_damaged_quantity'] = $distributor_damaged_quantity;

        return $this;
    }
    /**
     * Gets carrier_damaged_quantity
     *
     * @return int|null
     */
    public function getCarrierDamagedQuantity()
    {
        return $this->container['carrier_damaged_quantity'];
    }

    /**
     * Sets carrier_damaged_quantity
     *
     * @param int|null $carrier_damaged_quantity The number of units in carrier damaged disposition.
     *
     * @return self
     */
    public function setCarrierDamagedQuantity($carrier_damaged_quantity)
    {
        $this->container['carrier_damaged_quantity'] = $carrier_damaged_quantity;

        return $this;
    }
    /**
     * Gets defective_quantity
     *
     * @return int|null
     */
    public function getDefectiveQuantity()
    {
        return $this->container['defective_quantity'];
    }

    /**
     * Sets defective_quantity
     *
     * @param int|null $defective_quantity The number of units in defective disposition.
     *
     * @return self
     */
    public function setDefectiveQuantity($defective_quantity)
    {
        $this->container['defective_quantity'] = $defective_quantity;

        return $this;
    }
    /**
     * Gets expired_quantity
     *
     * @return int|null
     */
    public function getExpiredQuantity()
    {
        return $this->container['expired_quantity'];
    }

    /**
     * Sets expired_quantity
     *
     * @param int|null $expired_quantity The number of units in expired disposition.
     *
     * @return self
     */
    public function setExpiredQuantity($expired_quantity)
    {
        $this->container['expired_quantity'] = $expired_quantity;

        return $this;
    }
}


