<?php
/**
 * FeesEstimate
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  SellingPartnerApi
 */

/**
 * Selling Partner API for Product Fees
 *
 * The Selling Partner API for Product Fees lets you programmatically retrieve estimated fees for a product. You can then account for those fees in your pricing.
 *
 * The version of the OpenAPI document: v0
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SellingPartnerApi\Model\FeesV0;
use ArrayAccess;
use SellingPartnerApi\Model\BaseModel;
use SellingPartnerApi\Model\ModelInterface;
use SellingPartnerApi\ObjectSerializer;

/**
 * FeesEstimate Class Doc Comment
 *
 * @category Class
 * @description The total estimated fees for an item and a list of details.
 * @package  SellingPartnerApi
 * @group 
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class FeesEstimate extends BaseModel implements ModelInterface, ArrayAccess, \JsonSerializable, \IteratorAggregate
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'FeesEstimate';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'time_of_fees_estimation' => 'string',
        'total_fees_estimate' => '\SellingPartnerApi\Model\FeesV0\MoneyType',
        'fee_detail_list' => '\SellingPartnerApi\Model\FeesV0\FeeDetail[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'time_of_fees_estimation' => null,
        'total_fees_estimate' => null,
        'fee_detail_list' => null
    ];



    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'time_of_fees_estimation' => 'TimeOfFeesEstimation',
        'total_fees_estimate' => 'TotalFeesEstimate',
        'fee_detail_list' => 'FeeDetailList'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
                'time_of_fees_estimation' => 'setTimeOfFeesEstimation',
        'total_fees_estimate' => 'setTotalFeesEstimate',
        'fee_detail_list' => 'setFeeDetailList'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'time_of_fees_estimation' => 'getTimeOfFeesEstimation',
        'total_fees_estimate' => 'getTotalFeesEstimate',
        'fee_detail_list' => 'getFeeDetailList'
    ];


    
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['time_of_fees_estimation'] = $data['time_of_fees_estimation'] ?? null;
        $this->container['total_fees_estimate'] = $data['total_fees_estimate'] ?? null;
        $this->container['fee_detail_list'] = $data['fee_detail_list'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];
        if ($this->container['time_of_fees_estimation'] === null) {
            $invalidProperties[] = "'time_of_fees_estimation' can't be null";
        }
        return $invalidProperties;
    }


    /**
     * Gets time_of_fees_estimation
     *
     * @return string
     */
    public function getTimeOfFeesEstimation()
    {
        return $this->container['time_of_fees_estimation'];
    }

    /**
     * Sets time_of_fees_estimation
     *
     * @param string $time_of_fees_estimation The time at which the fees were estimated. This defaults to the time the request is made. Must be in ISO 8601 format.
     *
     * @return self
     */
    public function setTimeOfFeesEstimation($time_of_fees_estimation)
    {
        $this->container['time_of_fees_estimation'] = $time_of_fees_estimation;

        return $this;
    }
    /**
     * Gets total_fees_estimate
     *
     * @return \SellingPartnerApi\Model\FeesV0\MoneyType|null
     */
    public function getTotalFeesEstimate()
    {
        return $this->container['total_fees_estimate'];
    }

    /**
     * Sets total_fees_estimate
     *
     * @param \SellingPartnerApi\Model\FeesV0\MoneyType|null $total_fees_estimate total_fees_estimate
     *
     * @return self
     */
    public function setTotalFeesEstimate($total_fees_estimate)
    {
        $this->container['total_fees_estimate'] = $total_fees_estimate;

        return $this;
    }
    /**
     * Gets fee_detail_list
     *
     * @return \SellingPartnerApi\Model\FeesV0\FeeDetail[]|null
     */
    public function getFeeDetailList()
    {
        return $this->container['fee_detail_list'];
    }

    /**
     * Sets fee_detail_list
     *
     * @param \SellingPartnerApi\Model\FeesV0\FeeDetail[]|null $fee_detail_list A list of other fees that contribute to a given fee.
     *
     * @return self
     */
    public function setFeeDetailList($fee_detail_list)
    {
        $this->container['fee_detail_list'] = $fee_detail_list;

        return $this;
    }
}


