<?php
/**
 * ServiceFeeEvent
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  SellingPartnerApi
 */

/**
 * Selling Partner API for Finances
 *
 * The Selling Partner API for Finances helps you obtain financial information relevant to a seller's business. You can obtain financial events for a given order, financial event group, or date range without having to wait until a statement period closes. You can also obtain financial event groups for a given date range.
 *
 * The version of the OpenAPI document: v0
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SellingPartnerApi\Model\FinancesV0;
use ArrayAccess;
use SellingPartnerApi\Model\BaseModel;
use SellingPartnerApi\Model\ModelInterface;
use SellingPartnerApi\ObjectSerializer;

/**
 * ServiceFeeEvent Class Doc Comment
 *
 * @category Class
 * @description A service fee on the seller's account.
 * @package  SellingPartnerApi
 * @group 
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class ServiceFeeEvent extends BaseModel implements ModelInterface, ArrayAccess, \JsonSerializable, \IteratorAggregate
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ServiceFeeEvent';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'amazon_order_id' => 'string',
        'fee_reason' => 'string',
        'fee_list' => '\SellingPartnerApi\Model\FinancesV0\FeeComponent[]',
        'seller_sku' => 'string',
        'fn_sku' => 'string',
        'fee_description' => 'string',
        'asin' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'amazon_order_id' => null,
        'fee_reason' => null,
        'fee_list' => null,
        'seller_sku' => null,
        'fn_sku' => null,
        'fee_description' => null,
        'asin' => null
    ];



    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'amazon_order_id' => 'AmazonOrderId',
        'fee_reason' => 'FeeReason',
        'fee_list' => 'FeeList',
        'seller_sku' => 'SellerSKU',
        'fn_sku' => 'FnSKU',
        'fee_description' => 'FeeDescription',
        'asin' => 'ASIN'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
                'amazon_order_id' => 'setAmazonOrderId',
        'fee_reason' => 'setFeeReason',
        'fee_list' => 'setFeeList',
        'seller_sku' => 'setSellerSku',
        'fn_sku' => 'setFnSku',
        'fee_description' => 'setFeeDescription',
        'asin' => 'setAsin'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'amazon_order_id' => 'getAmazonOrderId',
        'fee_reason' => 'getFeeReason',
        'fee_list' => 'getFeeList',
        'seller_sku' => 'getSellerSku',
        'fn_sku' => 'getFnSku',
        'fee_description' => 'getFeeDescription',
        'asin' => 'getAsin'
    ];


    
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['amazon_order_id'] = $data['amazon_order_id'] ?? null;
        $this->container['fee_reason'] = $data['fee_reason'] ?? null;
        $this->container['fee_list'] = $data['fee_list'] ?? null;
        $this->container['seller_sku'] = $data['seller_sku'] ?? null;
        $this->container['fn_sku'] = $data['fn_sku'] ?? null;
        $this->container['fee_description'] = $data['fee_description'] ?? null;
        $this->container['asin'] = $data['asin'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];
        return $invalidProperties;
    }


    /**
     * Gets amazon_order_id
     *
     * @return string|null
     */
    public function getAmazonOrderId()
    {
        return $this->container['amazon_order_id'];
    }

    /**
     * Sets amazon_order_id
     *
     * @param string|null $amazon_order_id An Amazon-defined identifier for an order.
     *
     * @return self
     */
    public function setAmazonOrderId($amazon_order_id)
    {
        $this->container['amazon_order_id'] = $amazon_order_id;

        return $this;
    }
    /**
     * Gets fee_reason
     *
     * @return string|null
     */
    public function getFeeReason()
    {
        return $this->container['fee_reason'];
    }

    /**
     * Sets fee_reason
     *
     * @param string|null $fee_reason A short description of the service fee reason.
     *
     * @return self
     */
    public function setFeeReason($fee_reason)
    {
        $this->container['fee_reason'] = $fee_reason;

        return $this;
    }
    /**
     * Gets fee_list
     *
     * @return \SellingPartnerApi\Model\FinancesV0\FeeComponent[]|null
     */
    public function getFeeList()
    {
        return $this->container['fee_list'];
    }

    /**
     * Sets fee_list
     *
     * @param \SellingPartnerApi\Model\FinancesV0\FeeComponent[]|null $fee_list A list of fee component information.
     *
     * @return self
     */
    public function setFeeList($fee_list)
    {
        $this->container['fee_list'] = $fee_list;

        return $this;
    }
    /**
     * Gets seller_sku
     *
     * @return string|null
     */
    public function getSellerSku()
    {
        return $this->container['seller_sku'];
    }

    /**
     * Sets seller_sku
     *
     * @param string|null $seller_sku The seller SKU of the item. The seller SKU is qualified by the seller's seller ID, which is included with every call to the Selling Partner API.
     *
     * @return self
     */
    public function setSellerSku($seller_sku)
    {
        $this->container['seller_sku'] = $seller_sku;

        return $this;
    }
    /**
     * Gets fn_sku
     *
     * @return string|null
     */
    public function getFnSku()
    {
        return $this->container['fn_sku'];
    }

    /**
     * Sets fn_sku
     *
     * @param string|null $fn_sku A unique identifier assigned by Amazon to products stored in and fulfilled from an Amazon fulfillment center.
     *
     * @return self
     */
    public function setFnSku($fn_sku)
    {
        $this->container['fn_sku'] = $fn_sku;

        return $this;
    }
    /**
     * Gets fee_description
     *
     * @return string|null
     */
    public function getFeeDescription()
    {
        return $this->container['fee_description'];
    }

    /**
     * Sets fee_description
     *
     * @param string|null $fee_description A short description of the service fee event.
     *
     * @return self
     */
    public function setFeeDescription($fee_description)
    {
        $this->container['fee_description'] = $fee_description;

        return $this;
    }
    /**
     * Gets asin
     *
     * @return string|null
     */
    public function getAsin()
    {
        return $this->container['asin'];
    }

    /**
     * Sets asin
     *
     * @param string|null $asin The Amazon Standard Identification Number (ASIN) of the item.
     *
     * @return self
     */
    public function setAsin($asin)
    {
        $this->container['asin'] = $asin;

        return $this;
    }
}


