<?php
/**
 * SellerFeedbackType
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  SellingPartnerApi
 */

/**
 * Selling Partner API for Pricing
 *
 * The Selling Partner API for Pricing helps you programmatically retrieve product pricing and offer information for Amazon Marketplace products.
 *
 * The version of the OpenAPI document: v0
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SellingPartnerApi\Model\ProductPricingV0;
use ArrayAccess;
use SellingPartnerApi\Model\BaseModel;
use SellingPartnerApi\Model\ModelInterface;
use SellingPartnerApi\ObjectSerializer;

/**
 * SellerFeedbackType Class Doc Comment
 *
 * @category Class
 * @description Information about the seller's feedback, including the percentage of positive feedback, and the total number of ratings received.
 * @package  SellingPartnerApi
 * @group 
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class SellerFeedbackType extends BaseModel implements ModelInterface, ArrayAccess, \JsonSerializable, \IteratorAggregate
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'SellerFeedbackType';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'seller_positive_feedback_rating' => 'double',
        'feedback_count' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'seller_positive_feedback_rating' => 'double',
        'feedback_count' => 'int64'
    ];



    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'seller_positive_feedback_rating' => 'SellerPositiveFeedbackRating',
        'feedback_count' => 'FeedbackCount'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
                'seller_positive_feedback_rating' => 'setSellerPositiveFeedbackRating',
        'feedback_count' => 'setFeedbackCount'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'seller_positive_feedback_rating' => 'getSellerPositiveFeedbackRating',
        'feedback_count' => 'getFeedbackCount'
    ];


    
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['seller_positive_feedback_rating'] = $data['seller_positive_feedback_rating'] ?? null;
        $this->container['feedback_count'] = $data['feedback_count'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];
        if ($this->container['feedback_count'] === null) {
            $invalidProperties[] = "'feedback_count' can't be null";
        }
        return $invalidProperties;
    }


    /**
     * Gets seller_positive_feedback_rating
     *
     * @return double|null
     */
    public function getSellerPositiveFeedbackRating()
    {
        return $this->container['seller_positive_feedback_rating'];
    }

    /**
     * Sets seller_positive_feedback_rating
     *
     * @param double|null $seller_positive_feedback_rating The percentage of positive feedback for the seller in the past 365 days.
     *
     * @return self
     */
    public function setSellerPositiveFeedbackRating($seller_positive_feedback_rating)
    {
        $this->container['seller_positive_feedback_rating'] = $seller_positive_feedback_rating;

        return $this;
    }
    /**
     * Gets feedback_count
     *
     * @return int
     */
    public function getFeedbackCount()
    {
        return $this->container['feedback_count'];
    }

    /**
     * Sets feedback_count
     *
     * @param int $feedback_count The number of ratings received about the seller.
     *
     * @return self
     */
    public function setFeedbackCount($feedback_count)
    {
        $this->container['feedback_count'] = $feedback_count;

        return $this;
    }
}


