<?php
/**
 * IneligibilityReasonCode
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  SellingPartnerApi
 */

/**
 * Amazon Shipping API
 *
 * The Amazon Shipping API is designed to support outbound shipping use cases both for orders originating on Amazon-owned marketplaces as well as external channels/marketplaces. With these APIs, you can request shipping rates, create shipments, cancel shipments, and track shipments.
 *
 * The version of the OpenAPI document: v2
 * Contact: swa-api-core@amazon.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SellingPartnerApi\Model\ShippingV2;
use ArrayAccess;

use SellingPartnerApi\Model\ModelInterface;
use SellingPartnerApi\ObjectSerializer;

/**
 * IneligibilityReasonCode Class Doc Comment
 *
 * @category Class
 * @description Reasons that make a shipment service offering ineligible.
 * @package  SellingPartnerApi
 * @group 
 */
class IneligibilityReasonCode
{
    public $value;

    /**
     * Possible values of this enum
     */
    const NO_COVERAGE = 'NO_COVERAGE';
    const PICKUP_SLOT_RESTRICTION = 'PICKUP_SLOT_RESTRICTION';
    const UNSUPPORTED_VAS = 'UNSUPPORTED_VAS';
    const VAS_COMBINATION_RESTRICTION = 'VAS_COMBINATION_RESTRICTION';
    const SIZE_RESTRICTIONS = 'SIZE_RESTRICTIONS';
    const WEIGHT_RESTRICTIONS = 'WEIGHT_RESTRICTIONS';
    const LATE_DELIVERY = 'LATE_DELIVERY';
    const PROGRAM_CONSTRAINTS = 'PROGRAM_CONSTRAINTS';
    const TERMS_AND_CONDITIONS_NOT_ACCEPTED = 'TERMS_AND_CONDITIONS_NOT_ACCEPTED';
    const UNKNOWN = 'UNKNOWN';
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public static function getAllowableEnumValues()
    {
        $baseVals = [
            self::NO_COVERAGE,
            self::PICKUP_SLOT_RESTRICTION,
            self::UNSUPPORTED_VAS,
            self::VAS_COMBINATION_RESTRICTION,
            self::SIZE_RESTRICTIONS,
            self::WEIGHT_RESTRICTIONS,
            self::LATE_DELIVERY,
            self::PROGRAM_CONSTRAINTS,
            self::TERMS_AND_CONDITIONS_NOT_ACCEPTED,
            self::UNKNOWN,
        ];
        // This is necessary because Amazon does not consistently capitalize their
        // enum values, so we do case-insensitive enum value validation in ObjectSerializer
        $ucVals = array_map(function ($val) { return strtoupper($val); }, $baseVals);
        return array_merge($baseVals, $ucVals);
    }

    public function __construct($value)
    {
        if (is_null($value) || !in_array($value, self::getAllowableEnumValues(), true)) {
            throw new \InvalidArgumentException(sprintf("Invalid value %s for enum 'IneligibilityReasonCode', must be one of '%s'", $value, implode("', '", self::getAllowableEnumValues())));
        }

        $this->value = $value;
    }

    /**
     * Convert the enum value to a string.
     *
     * @return string
     */
    public function __toString()
    {
        return $this->value;
    }
}


