<?php
/**
 * Package
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  SellingPartnerApi
 */

/**
 * Amazon Shipping API
 *
 * The Amazon Shipping API is designed to support outbound shipping use cases both for orders originating on Amazon-owned marketplaces as well as external channels/marketplaces. With these APIs, you can request shipping rates, create shipments, cancel shipments, and track shipments.
 *
 * The version of the OpenAPI document: v2
 * Contact: swa-api-core@amazon.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SellingPartnerApi\Model\ShippingV2;
use ArrayAccess;
use SellingPartnerApi\Model\BaseModel;
use SellingPartnerApi\Model\ModelInterface;
use SellingPartnerApi\ObjectSerializer;

/**
 * Package Class Doc Comment
 *
 * @category Class
 * @description A package to be shipped through a shipping service offering.
 * @package  SellingPartnerApi
 * @group 
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class Package extends BaseModel implements ModelInterface, ArrayAccess, \JsonSerializable, \IteratorAggregate
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Package';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'dimensions' => '\SellingPartnerApi\Model\ShippingV2\Dimensions',
        'weight' => '\SellingPartnerApi\Model\ShippingV2\Weight',
        'insured_value' => '\SellingPartnerApi\Model\ShippingV2\Currency',
        'is_hazmat' => 'bool',
        'seller_display_name' => 'string',
        'charges' => '\SellingPartnerApi\Model\ShippingV2\ChargeComponent[]',
        'package_client_reference_id' => 'string',
        'items' => '\SellingPartnerApi\Model\ShippingV2\Item[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'dimensions' => null,
        'weight' => null,
        'insured_value' => null,
        'is_hazmat' => null,
        'seller_display_name' => null,
        'charges' => null,
        'package_client_reference_id' => null,
        'items' => null
    ];



    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'dimensions' => 'dimensions',
        'weight' => 'weight',
        'insured_value' => 'insuredValue',
        'is_hazmat' => 'isHazmat',
        'seller_display_name' => 'sellerDisplayName',
        'charges' => 'charges',
        'package_client_reference_id' => 'packageClientReferenceId',
        'items' => 'items'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
                'dimensions' => 'setDimensions',
        'weight' => 'setWeight',
        'insured_value' => 'setInsuredValue',
        'is_hazmat' => 'setIsHazmat',
        'seller_display_name' => 'setSellerDisplayName',
        'charges' => 'setCharges',
        'package_client_reference_id' => 'setPackageClientReferenceId',
        'items' => 'setItems'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'dimensions' => 'getDimensions',
        'weight' => 'getWeight',
        'insured_value' => 'getInsuredValue',
        'is_hazmat' => 'getIsHazmat',
        'seller_display_name' => 'getSellerDisplayName',
        'charges' => 'getCharges',
        'package_client_reference_id' => 'getPackageClientReferenceId',
        'items' => 'getItems'
    ];


    
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['dimensions'] = $data['dimensions'] ?? null;
        $this->container['weight'] = $data['weight'] ?? null;
        $this->container['insured_value'] = $data['insured_value'] ?? null;
        $this->container['is_hazmat'] = $data['is_hazmat'] ?? null;
        $this->container['seller_display_name'] = $data['seller_display_name'] ?? null;
        $this->container['charges'] = $data['charges'] ?? null;
        $this->container['package_client_reference_id'] = $data['package_client_reference_id'] ?? null;
        $this->container['items'] = $data['items'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];
        if ($this->container['dimensions'] === null) {
            $invalidProperties[] = "'dimensions' can't be null";
        }
        if ($this->container['weight'] === null) {
            $invalidProperties[] = "'weight' can't be null";
        }
        if ($this->container['insured_value'] === null) {
            $invalidProperties[] = "'insured_value' can't be null";
        }
        if ($this->container['package_client_reference_id'] === null) {
            $invalidProperties[] = "'package_client_reference_id' can't be null";
        }
        if ($this->container['items'] === null) {
            $invalidProperties[] = "'items' can't be null";
        }
        return $invalidProperties;
    }


    /**
     * Gets dimensions
     *
     * @return \SellingPartnerApi\Model\ShippingV2\Dimensions
     */
    public function getDimensions()
    {
        return $this->container['dimensions'];
    }

    /**
     * Sets dimensions
     *
     * @param \SellingPartnerApi\Model\ShippingV2\Dimensions $dimensions dimensions
     *
     * @return self
     */
    public function setDimensions($dimensions)
    {
        $this->container['dimensions'] = $dimensions;

        return $this;
    }
    /**
     * Gets weight
     *
     * @return \SellingPartnerApi\Model\ShippingV2\Weight
     */
    public function getWeight()
    {
        return $this->container['weight'];
    }

    /**
     * Sets weight
     *
     * @param \SellingPartnerApi\Model\ShippingV2\Weight $weight weight
     *
     * @return self
     */
    public function setWeight($weight)
    {
        $this->container['weight'] = $weight;

        return $this;
    }
    /**
     * Gets insured_value
     *
     * @return \SellingPartnerApi\Model\ShippingV2\Currency
     */
    public function getInsuredValue()
    {
        return $this->container['insured_value'];
    }

    /**
     * Sets insured_value
     *
     * @param \SellingPartnerApi\Model\ShippingV2\Currency $insured_value insured_value
     *
     * @return self
     */
    public function setInsuredValue($insured_value)
    {
        $this->container['insured_value'] = $insured_value;

        return $this;
    }
    /**
     * Gets is_hazmat
     *
     * @return bool|null
     */
    public function getIsHazmat()
    {
        return $this->container['is_hazmat'];
    }

    /**
     * Sets is_hazmat
     *
     * @param bool|null $is_hazmat When true, the package contains hazardous materials. Defaults to false.
     *
     * @return self
     */
    public function setIsHazmat($is_hazmat)
    {
        $this->container['is_hazmat'] = $is_hazmat;

        return $this;
    }
    /**
     * Gets seller_display_name
     *
     * @return string|null
     */
    public function getSellerDisplayName()
    {
        return $this->container['seller_display_name'];
    }

    /**
     * Sets seller_display_name
     *
     * @param string|null $seller_display_name The seller name displayed on the label.
     *
     * @return self
     */
    public function setSellerDisplayName($seller_display_name)
    {
        $this->container['seller_display_name'] = $seller_display_name;

        return $this;
    }
    /**
     * Gets charges
     *
     * @return \SellingPartnerApi\Model\ShippingV2\ChargeComponent[]|null
     */
    public function getCharges()
    {
        return $this->container['charges'];
    }

    /**
     * Sets charges
     *
     * @param \SellingPartnerApi\Model\ShippingV2\ChargeComponent[]|null $charges A list of charges based on the shipping service charges applied on a package.
     *
     * @return self
     */
    public function setCharges($charges)
    {
        $this->container['charges'] = $charges;

        return $this;
    }
    /**
     * Gets package_client_reference_id
     *
     * @return string
     */
    public function getPackageClientReferenceId()
    {
        return $this->container['package_client_reference_id'];
    }

    /**
     * Sets package_client_reference_id
     *
     * @param string $package_client_reference_id A client provided unique identifier for a package being shipped. This value should be saved by the client to pass as a parameter to the getShipmentDocuments operation.
     *
     * @return self
     */
    public function setPackageClientReferenceId($package_client_reference_id)
    {
        $this->container['package_client_reference_id'] = $package_client_reference_id;

        return $this;
    }
    /**
     * Gets items
     *
     * @return \SellingPartnerApi\Model\ShippingV2\Item[]
     */
    public function getItems()
    {
        return $this->container['items'];
    }

    /**
     * Sets items
     *
     * @param \SellingPartnerApi\Model\ShippingV2\Item[] $items A list of items.
     *
     * @return self
     */
    public function setItems($items)
    {
        $this->container['items'] = $items;

        return $this;
    }
}


