<?php
/**
 * Duration
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  SellingPartnerApi
 */

/**
 * Selling Partner API for Retail Procurement Shipments
 *
 * The Selling Partner API for Retail Procurement Shipments provides programmatic access to retail shipping data for vendors.
 *
 * The version of the OpenAPI document: v1
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SellingPartnerApi\Model\VendorShippingV1;
use ArrayAccess;
use SellingPartnerApi\Model\BaseModel;
use SellingPartnerApi\Model\ModelInterface;
use SellingPartnerApi\ObjectSerializer;

/**
 * Duration Class Doc Comment
 *
 * @category Class
 * @package  SellingPartnerApi
 * @group 
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class Duration extends BaseModel implements ModelInterface, ArrayAccess, \JsonSerializable, \IteratorAggregate
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Duration';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'duration_unit' => 'string',
        'duration_value' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'duration_unit' => null,
        'duration_value' => null
    ];



    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'duration_unit' => 'durationUnit',
        'duration_value' => 'durationValue'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
                'duration_unit' => 'setDurationUnit',
        'duration_value' => 'setDurationValue'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'duration_unit' => 'getDurationUnit',
        'duration_value' => 'getDurationValue'
    ];



    const DURATION_UNIT_DAYS = 'Days';
    const DURATION_UNIT_MONTHS = 'Months';
    
    

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getDurationUnitAllowableValues()
    {
        $baseVals = [
            self::DURATION_UNIT_DAYS,
            self::DURATION_UNIT_MONTHS,
        ];

        // This is necessary because Amazon does not consistently capitalize their
        // enum values, so we do case-insensitive enum value validation in ObjectSerializer
        return array_map(function ($val) { return strtoupper($val); }, $baseVals);
    }
    
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['duration_unit'] = $data['duration_unit'] ?? null;
        $this->container['duration_value'] = $data['duration_value'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];
        if ($this->container['duration_unit'] === null) {
            $invalidProperties[] = "'duration_unit' can't be null";
        }
        $allowedValues = $this->getDurationUnitAllowableValues();
        if (
            !is_null($this->container['duration_unit']) &&
            !in_array(strtoupper($this->container['duration_unit']), $allowedValues, true)
        ) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'duration_unit', must be one of '%s'",
                $this->container['duration_unit'],
                implode("', '", $allowedValues)
            );
        }

        if ($this->container['duration_value'] === null) {
            $invalidProperties[] = "'duration_value' can't be null";
        }
        return $invalidProperties;
    }


    /**
     * Gets duration_unit
     *
     * @return string
     */
    public function getDurationUnit()
    {
        return $this->container['duration_unit'];
    }

    /**
     * Sets duration_unit
     *
     * @param string $duration_unit Unit for duration.
     *
     * @return self
     */
    public function setDurationUnit($duration_unit)
    {
        $allowedValues = $this->getDurationUnitAllowableValues();
        if (!in_array(strtoupper($duration_unit), $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'duration_unit', must be one of '%s'",
                    $duration_unit,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['duration_unit'] = $duration_unit;

        return $this;
    }
    /**
     * Gets duration_value
     *
     * @return int
     */
    public function getDurationValue()
    {
        return $this->container['duration_value'];
    }

    /**
     * Sets duration_value
     *
     * @param int $duration_value Value for the duration in terms of the durationUnit.
     *
     * @return self
     */
    public function setDurationValue($duration_value)
    {
        $this->container['duration_value'] = $duration_value;

        return $this;
    }
}


