<?php
/**
 * DebtRecoveryItem
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  SellingPartnerApi
 */

/**
 * Selling Partner API for Finances
 *
 * The Selling Partner API for Finances helps you obtain financial information relevant to a seller's business. You can obtain financial events for a given order, financial event group, or date range without having to wait until a statement period closes. You can also obtain financial event groups for a given date range.
 *
 * The version of the OpenAPI document: v0
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SellingPartnerApi\Model\FinancesV0;
use ArrayAccess;
use SellingPartnerApi\Model\BaseModel;
use SellingPartnerApi\Model\ModelInterface;
use SellingPartnerApi\ObjectSerializer;

/**
 * DebtRecoveryItem Class Doc Comment
 *
 * @category Class
 * @description An item of a debt payment or debt adjustment.
 * @package  SellingPartnerApi
 * @group 
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class DebtRecoveryItem extends BaseModel implements ModelInterface, ArrayAccess, \JsonSerializable, \IteratorAggregate
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'DebtRecoveryItem';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'recovery_amount' => '\SellingPartnerApi\Model\FinancesV0\Currency',
        'original_amount' => '\SellingPartnerApi\Model\FinancesV0\Currency',
        'group_begin_date' => 'string',
        'group_end_date' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'recovery_amount' => null,
        'original_amount' => null,
        'group_begin_date' => null,
        'group_end_date' => null
    ];



    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'recovery_amount' => 'RecoveryAmount',
        'original_amount' => 'OriginalAmount',
        'group_begin_date' => 'GroupBeginDate',
        'group_end_date' => 'GroupEndDate'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
                'recovery_amount' => 'setRecoveryAmount',
        'original_amount' => 'setOriginalAmount',
        'group_begin_date' => 'setGroupBeginDate',
        'group_end_date' => 'setGroupEndDate'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'recovery_amount' => 'getRecoveryAmount',
        'original_amount' => 'getOriginalAmount',
        'group_begin_date' => 'getGroupBeginDate',
        'group_end_date' => 'getGroupEndDate'
    ];


    
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['recovery_amount'] = $data['recovery_amount'] ?? null;
        $this->container['original_amount'] = $data['original_amount'] ?? null;
        $this->container['group_begin_date'] = $data['group_begin_date'] ?? null;
        $this->container['group_end_date'] = $data['group_end_date'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];
        return $invalidProperties;
    }


    /**
     * Gets recovery_amount
     *
     * @return \SellingPartnerApi\Model\FinancesV0\Currency|null
     */
    public function getRecoveryAmount()
    {
        return $this->container['recovery_amount'];
    }

    /**
     * Sets recovery_amount
     *
     * @param \SellingPartnerApi\Model\FinancesV0\Currency|null $recovery_amount recovery_amount
     *
     * @return self
     */
    public function setRecoveryAmount($recovery_amount)
    {
        $this->container['recovery_amount'] = $recovery_amount;

        return $this;
    }
    /**
     * Gets original_amount
     *
     * @return \SellingPartnerApi\Model\FinancesV0\Currency|null
     */
    public function getOriginalAmount()
    {
        return $this->container['original_amount'];
    }

    /**
     * Sets original_amount
     *
     * @param \SellingPartnerApi\Model\FinancesV0\Currency|null $original_amount original_amount
     *
     * @return self
     */
    public function setOriginalAmount($original_amount)
    {
        $this->container['original_amount'] = $original_amount;

        return $this;
    }
    /**
     * Gets group_begin_date
     *
     * @return string|null
     */
    public function getGroupBeginDate()
    {
        return $this->container['group_begin_date'];
    }

    /**
     * Sets group_begin_date
     *
     * @param string|null $group_begin_date A date string in ISO 8601 format.
     *
     * @return self
     */
    public function setGroupBeginDate($group_begin_date)
    {
        $this->container['group_begin_date'] = $group_begin_date;

        return $this;
    }
    /**
     * Gets group_end_date
     *
     * @return string|null
     */
    public function getGroupEndDate()
    {
        return $this->container['group_end_date'];
    }

    /**
     * Sets group_end_date
     *
     * @param string|null $group_end_date A date string in ISO 8601 format.
     *
     * @return self
     */
    public function setGroupEndDate($group_end_date)
    {
        $this->container['group_end_date'] = $group_end_date;

        return $this;
    }
}


