<?php
/**
 * CreateWarrantyRequest
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  SellingPartnerApi
 */

/**
 * Selling Partner API for Messaging
 *
 * With the Messaging API you can build applications that send messages to buyers. You can get a list of message types that are available for an order that you specify, then call an operation that sends a message to the buyer for that order. The Messaging API returns responses that are formed according to the <a href=https://tools.ietf.org/html/draft-kelly-json-hal-08>JSON Hypertext Application Language</a> (HAL) standard.
 *
 * The version of the OpenAPI document: v1
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SellingPartnerApi\Model\MessagingV1;
use ArrayAccess;
use SellingPartnerApi\Model\BaseModel;
use SellingPartnerApi\Model\ModelInterface;
use SellingPartnerApi\ObjectSerializer;

/**
 * CreateWarrantyRequest Class Doc Comment
 *
 * @category Class
 * @description The request schema for the createWarranty operation.
 * @package  SellingPartnerApi
 * @group 
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class CreateWarrantyRequest extends BaseModel implements ModelInterface, ArrayAccess, \JsonSerializable, \IteratorAggregate
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'CreateWarrantyRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'attachments' => '\SellingPartnerApi\Model\MessagingV1\Attachment[]',
        'coverage_start_date' => 'string',
        'coverage_end_date' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'attachments' => null,
        'coverage_start_date' => null,
        'coverage_end_date' => null
    ];



    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'attachments' => 'attachments',
        'coverage_start_date' => 'coverageStartDate',
        'coverage_end_date' => 'coverageEndDate'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
                'attachments' => 'setAttachments',
        'coverage_start_date' => 'setCoverageStartDate',
        'coverage_end_date' => 'setCoverageEndDate'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'attachments' => 'getAttachments',
        'coverage_start_date' => 'getCoverageStartDate',
        'coverage_end_date' => 'getCoverageEndDate'
    ];


    
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['attachments'] = $data['attachments'] ?? null;
        $this->container['coverage_start_date'] = $data['coverage_start_date'] ?? null;
        $this->container['coverage_end_date'] = $data['coverage_end_date'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];
        return $invalidProperties;
    }


    /**
     * Gets attachments
     *
     * @return \SellingPartnerApi\Model\MessagingV1\Attachment[]|null
     */
    public function getAttachments()
    {
        return $this->container['attachments'];
    }

    /**
     * Sets attachments
     *
     * @param \SellingPartnerApi\Model\MessagingV1\Attachment[]|null $attachments Attachments to include in the message to the buyer. If any text is included in the attachment, the text must be written in the buyer's language of preference, which can be retrieved from the GetAttributes operation.
     *
     * @return self
     */
    public function setAttachments($attachments)
    {
        $this->container['attachments'] = $attachments;

        return $this;
    }
    /**
     * Gets coverage_start_date
     *
     * @return string|null
     */
    public function getCoverageStartDate()
    {
        return $this->container['coverage_start_date'];
    }

    /**
     * Sets coverage_start_date
     *
     * @param string|null $coverage_start_date The start date of the warranty coverage to include in the message to the buyer. Must be in ISO 8601 format.
     *
     * @return self
     */
    public function setCoverageStartDate($coverage_start_date)
    {
        $this->container['coverage_start_date'] = $coverage_start_date;

        return $this;
    }
    /**
     * Gets coverage_end_date
     *
     * @return string|null
     */
    public function getCoverageEndDate()
    {
        return $this->container['coverage_end_date'];
    }

    /**
     * Sets coverage_end_date
     *
     * @param string|null $coverage_end_date The end date of the warranty coverage to include in the message to the buyer. Must be in ISO 8601 format.
     *
     * @return self
     */
    public function setCoverageEndDate($coverage_end_date)
    {
        $this->container['coverage_end_date'] = $coverage_end_date;

        return $this;
    }
}


