<?php
/**
 * ServiceLocation
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  SellingPartnerApi
 */

/**
 * Selling Partner API for Services
 *
 * With the Services API, you can build applications that help service providers get and modify their service orders and manage their resources.
 *
 * The version of the OpenAPI document: v1
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SellingPartnerApi\Model\ServiceV1;
use ArrayAccess;
use SellingPartnerApi\Model\BaseModel;
use SellingPartnerApi\Model\ModelInterface;
use SellingPartnerApi\ObjectSerializer;

/**
 * ServiceLocation Class Doc Comment
 *
 * @category Class
 * @description Information about the location of the service job.
 * @package  SellingPartnerApi
 * @group 
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class ServiceLocation extends BaseModel implements ModelInterface, ArrayAccess, \JsonSerializable, \IteratorAggregate
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ServiceLocation';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'service_location_type' => 'string',
        'address' => '\SellingPartnerApi\Model\ServiceV1\Address'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'service_location_type' => null,
        'address' => null
    ];



    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'service_location_type' => 'serviceLocationType',
        'address' => 'address'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
                'service_location_type' => 'setServiceLocationType',
        'address' => 'setAddress'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'service_location_type' => 'getServiceLocationType',
        'address' => 'getAddress'
    ];



    const SERVICE_LOCATION_TYPE_IN_HOME = 'IN_HOME';
    const SERVICE_LOCATION_TYPE_IN_STORE = 'IN_STORE';
    const SERVICE_LOCATION_TYPE_ONLINE = 'ONLINE';
    
    

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getServiceLocationTypeAllowableValues()
    {
        $baseVals = [
            self::SERVICE_LOCATION_TYPE_IN_HOME,
            self::SERVICE_LOCATION_TYPE_IN_STORE,
            self::SERVICE_LOCATION_TYPE_ONLINE,
        ];

        // This is necessary because Amazon does not consistently capitalize their
        // enum values, so we do case-insensitive enum value validation in ObjectSerializer
        return array_map(function ($val) { return strtoupper($val); }, $baseVals);
    }
    
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['service_location_type'] = $data['service_location_type'] ?? null;
        $this->container['address'] = $data['address'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];
        $allowedValues = $this->getServiceLocationTypeAllowableValues();
        if (
            !is_null($this->container['service_location_type']) &&
            !in_array(strtoupper($this->container['service_location_type']), $allowedValues, true)
        ) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'service_location_type', must be one of '%s'",
                $this->container['service_location_type'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }


    /**
     * Gets service_location_type
     *
     * @return string|null
     */
    public function getServiceLocationType()
    {
        return $this->container['service_location_type'];
    }

    /**
     * Sets service_location_type
     *
     * @param string|null $service_location_type The location of the service job.
     *
     * @return self
     */
    public function setServiceLocationType($service_location_type)
    {
        $allowedValues = $this->getServiceLocationTypeAllowableValues();
        if (!is_null($service_location_type) &&!in_array(strtoupper($service_location_type), $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'service_location_type', must be one of '%s'",
                    $service_location_type,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['service_location_type'] = $service_location_type;

        return $this;
    }
    /**
     * Gets address
     *
     * @return \SellingPartnerApi\Model\ServiceV1\Address|null
     */
    public function getAddress()
    {
        return $this->container['address'];
    }

    /**
     * Sets address
     *
     * @param \SellingPartnerApi\Model\ServiceV1\Address|null $address address
     *
     * @return self
     */
    public function setAddress($address)
    {
        $this->container['address'] = $address;

        return $this;
    }
}


