<?php

declare(strict_types=1);

namespace AmazonPHP\SellingPartner\Model\VendorDirectFulfillmentShipping;

use AmazonPHP\SellingPartner\Exception\AssertionException;
use AmazonPHP\SellingPartner\ModelInterface;
use AmazonPHP\SellingPartner\ObjectSerializer;

/**
 * Selling Partner API for Direct Fulfillment Shipping.
 *
 * The Selling Partner API for Direct Fulfillment Shipping provides programmatic access to a direct fulfillment vendor's shipping data.
 *
 * The version of the OpenAPI document: 2021-12-28
 *
 * This class was auto-generated by https://openapi-generator.tech
 * Do not change it, it will be overwritten with next execution of /bin/generate.sh
 *
 * @implements \ArrayAccess<TKey, TValue>
 *
 * @template TKey int|null
 * @template TValue mixed|null
 */
class StatusUpdateDetails implements \ArrayAccess, \JsonSerializable, \Stringable, ModelInterface
{
    final public const DISCRIMINATOR = null;

    /**
     * The original name of the model.
     *
     * @var string
     */
    protected static string $openAPIModelName = 'StatusUpdateDetails';

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @var string[]
     */
    protected static array $openAPITypes = [
        'tracking_number' => 'string',
        'status_code' => 'string',
        'reason_code' => 'string',
        'status_date_time' => '\DateTimeInterface',
        'status_location_address' => '\AmazonPHP\SellingPartner\Model\VendorDirectFulfillmentShipping\Address',
        'shipment_schedule' => '\AmazonPHP\SellingPartner\Model\VendorDirectFulfillmentShipping\ShipmentSchedule',
    ];

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @var string[]
     *
     * @phpstan-var array<string, string|null>
     *
     * @psalm-var array<string, string|null>
     */
    protected static array $openAPIFormats = [
        'tracking_number' => null,
        'status_code' => null,
        'reason_code' => null,
        'status_date_time' => 'date-time',
        'status_location_address' => null,
        'shipment_schedule' => null,
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @var string[]
     */
    protected static array $attributeMap = [
        'tracking_number' => 'trackingNumber',
        'status_code' => 'statusCode',
        'reason_code' => 'reasonCode',
        'status_date_time' => 'statusDateTime',
        'status_location_address' => 'statusLocationAddress',
        'shipment_schedule' => 'shipmentSchedule',
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @var string[]
     */
    protected static array $setters = [
        'tracking_number' => 'setTrackingNumber',
        'status_code' => 'setStatusCode',
        'reason_code' => 'setReasonCode',
        'status_date_time' => 'setStatusDateTime',
        'status_location_address' => 'setStatusLocationAddress',
        'shipment_schedule' => 'setShipmentSchedule',
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @var string[]
     */
    protected static array $getters = [
        'tracking_number' => 'getTrackingNumber',
        'status_code' => 'getStatusCode',
        'reason_code' => 'getReasonCode',
        'status_date_time' => 'getStatusDateTime',
        'status_location_address' => 'getStatusLocationAddress',
        'shipment_schedule' => 'getShipmentSchedule',
    ];

    /**
     * Associative array for storing property values.
     *
     * @var mixed[]
     */
    protected array $container = [];

    /**
     * Constructor.
     *
     * @param null|mixed[] $data Associated array of property values
     *                           initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['tracking_number'] = $data['tracking_number'] ?? null;
        $this->container['status_code'] = $data['status_code'] ?? null;
        $this->container['reason_code'] = $data['reason_code'] ?? null;
        $this->container['status_date_time'] = $data['status_date_time'] ?? null;
        $this->container['status_location_address'] = $data['status_location_address'] ?? null;
        $this->container['shipment_schedule'] = $data['shipment_schedule'] ?? null;
    }

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @return string[]
     */
    public static function openAPITypes() : array
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @return null[]|string[]
     */
    public static function openAPIFormats() : array
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @return string[]
     */
    public static function attributeMap() : array
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @return string[]
     */
    public static function setters() : array
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @return string[]
     */
    public static function getters() : array
    {
        return self::$getters;
    }

    /**
     * Gets the string presentation of the object.
     */
    public function __toString() : string
    {
        return \json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * The original name of the model.
     */
    public function getModelName() : string
    {
        return self::$openAPIModelName;
    }

    /**
     * Validate all properties.
     *
     * @throws AssertionException
     */
    public function validate() : void
    {
        if ($this->container['tracking_number'] === null) {
            throw new AssertionException("'tracking_number' can't be null");
        }

        if ($this->container['status_code'] === null) {
            throw new AssertionException("'status_code' can't be null");
        }

        if ($this->container['reason_code'] === null) {
            throw new AssertionException("'reason_code' can't be null");
        }

        if ($this->container['status_date_time'] === null) {
            throw new AssertionException("'status_date_time' can't be null");
        }

        if ($this->container['status_location_address'] === null) {
            throw new AssertionException("'status_location_address' can't be null");
        }

        $this->container['status_location_address']->validate();

        if ($this->container['shipment_schedule'] !== null) {
            $this->container['shipment_schedule']->validate();
        }
    }

    /**
     * Gets tracking_number.
     */
    public function getTrackingNumber() : string
    {
        return $this->container['tracking_number'];
    }

    /**
     * Sets tracking_number.
     *
     * @param string $tracking_number this is required to be provided for every package and should match with the trackingNumber sent for the shipment confirmation
     */
    public function setTrackingNumber(string $tracking_number) : self
    {
        $this->container['tracking_number'] = $tracking_number;

        return $this;
    }

    /**
     * Gets status_code.
     */
    public function getStatusCode() : string
    {
        return $this->container['status_code'];
    }

    /**
     * Sets status_code.
     *
     * @param string $status_code indicates the shipment status code of the package that provides transportation information for Amazon tracking systems and ultimately for the final customer
     */
    public function setStatusCode(string $status_code) : self
    {
        $this->container['status_code'] = $status_code;

        return $this;
    }

    /**
     * Gets reason_code.
     */
    public function getReasonCode() : string
    {
        return $this->container['reason_code'];
    }

    /**
     * Sets reason_code.
     *
     * @param string $reason_code provides a reason code for the status of the package that will provide additional information about the transportation status
     */
    public function setReasonCode(string $reason_code) : self
    {
        $this->container['reason_code'] = $reason_code;

        return $this;
    }

    /**
     * Gets status_date_time.
     */
    public function getStatusDateTime() : \DateTimeInterface
    {
        return $this->container['status_date_time'];
    }

    /**
     * Sets status_date_time.
     *
     * @param \DateTimeInterface $status_date_time The date and time when the shipment status was updated. This field is expected to be in ISO-8601 date/time format, with UTC time zone or UTC offset. For example, 2020-07-16T23:00:00Z or 2020-07-16T23:00:00+01:00.
     */
    public function setStatusDateTime(\DateTimeInterface $status_date_time) : self
    {
        $this->container['status_date_time'] = $status_date_time;

        return $this;
    }

    /**
     * Gets status_location_address.
     */
    public function getStatusLocationAddress() : Address
    {
        return $this->container['status_location_address'];
    }

    /**
     * Sets status_location_address.
     *
     * @param \AmazonPHP\SellingPartner\Model\VendorDirectFulfillmentShipping\Address $status_location_address status_location_address
     */
    public function setStatusLocationAddress(Address $status_location_address) : self
    {
        $this->container['status_location_address'] = $status_location_address;

        return $this;
    }

    /**
     * Gets shipment_schedule.
     */
    public function getShipmentSchedule() : ?ShipmentSchedule
    {
        return $this->container['shipment_schedule'];
    }

    /**
     * Sets shipment_schedule.
     *
     * @param null|\AmazonPHP\SellingPartner\Model\VendorDirectFulfillmentShipping\ShipmentSchedule $shipment_schedule shipment_schedule
     */
    public function setShipmentSchedule(?ShipmentSchedule $shipment_schedule) : self
    {
        $this->container['shipment_schedule'] = $shipment_schedule;

        return $this;
    }

    /**
     * Returns true if offset exists. False otherwise.
     */
    public function offsetExists($offset) : bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @return null|mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset) : mixed
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     */
    public function offsetSet($offset, $value) : void
    {
        if (null === $offset) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     */
    public function offsetUnset($offset) : void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     *
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed returns data which can be serialized by json_encode(), which is a value
     *               of any type other than a resource
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize() : string
    {
        return \json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR);
    }

    /**
     * Gets a header-safe presentation of the object.
     */
    public function toHeaderValue() : string
    {
        return \json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR);
    }
}
