<?php

declare(strict_types=1);

namespace AmazonPHP\SellingPartner\Model\ProductFees;

use AmazonPHP\SellingPartner\Exception\AssertionException;
use AmazonPHP\SellingPartner\ModelInterface;
use AmazonPHP\SellingPartner\ObjectSerializer;

/**
 * Selling Partner API for Product Fees.
 *
 * The Selling Partner API for Product Fees lets you programmatically retrieve estimated fees for a product. You can then account for those fees in your pricing.
 *
 * The version of the OpenAPI document: v0
 *
 * This class was auto-generated by https://openapi-generator.tech
 * Do not change it, it will be overwritten with next execution of /bin/generate.sh
 *
 * @implements \ArrayAccess<TKey, TValue>
 *
 * @template TKey int|null
 * @template TValue mixed|null
 */
class FeesEstimate implements \ArrayAccess, \JsonSerializable, \Stringable, ModelInterface
{
    final public const DISCRIMINATOR = null;

    /**
     * The original name of the model.
     *
     * @var string
     */
    protected static string $openAPIModelName = 'FeesEstimate';

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @var string[]
     */
    protected static array $openAPITypes = [
        'time_of_fees_estimation' => '\DateTimeInterface',
        'total_fees_estimate' => '\AmazonPHP\SellingPartner\Model\ProductFees\MoneyType',
        'fee_detail_list' => '\AmazonPHP\SellingPartner\Model\ProductFees\FeeDetail[]',
    ];

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @var string[]
     *
     * @phpstan-var array<string, string|null>
     *
     * @psalm-var array<string, string|null>
     */
    protected static array $openAPIFormats = [
        'time_of_fees_estimation' => 'date-time',
        'total_fees_estimate' => null,
        'fee_detail_list' => null,
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @var string[]
     */
    protected static array $attributeMap = [
        'time_of_fees_estimation' => 'TimeOfFeesEstimation',
        'total_fees_estimate' => 'TotalFeesEstimate',
        'fee_detail_list' => 'FeeDetailList',
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @var string[]
     */
    protected static array $setters = [
        'time_of_fees_estimation' => 'setTimeOfFeesEstimation',
        'total_fees_estimate' => 'setTotalFeesEstimate',
        'fee_detail_list' => 'setFeeDetailList',
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @var string[]
     */
    protected static array $getters = [
        'time_of_fees_estimation' => 'getTimeOfFeesEstimation',
        'total_fees_estimate' => 'getTotalFeesEstimate',
        'fee_detail_list' => 'getFeeDetailList',
    ];

    /**
     * Associative array for storing property values.
     *
     * @var mixed[]
     */
    protected array $container = [];

    /**
     * Constructor.
     *
     * @param null|mixed[] $data Associated array of property values
     *                           initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['time_of_fees_estimation'] = $data['time_of_fees_estimation'] ?? null;
        $this->container['total_fees_estimate'] = $data['total_fees_estimate'] ?? null;
        $this->container['fee_detail_list'] = $data['fee_detail_list'] ?? null;
    }

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @return string[]
     */
    public static function openAPITypes() : array
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @return null[]|string[]
     */
    public static function openAPIFormats() : array
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @return string[]
     */
    public static function attributeMap() : array
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @return string[]
     */
    public static function setters() : array
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @return string[]
     */
    public static function getters() : array
    {
        return self::$getters;
    }

    /**
     * Gets the string presentation of the object.
     */
    public function __toString() : string
    {
        return \json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * The original name of the model.
     */
    public function getModelName() : string
    {
        return self::$openAPIModelName;
    }

    /**
     * Validate all properties.
     *
     * @throws AssertionException
     */
    public function validate() : void
    {
        if ($this->container['time_of_fees_estimation'] === null) {
            throw new AssertionException("'time_of_fees_estimation' can't be null");
        }

        if ($this->container['total_fees_estimate'] !== null) {
            $this->container['total_fees_estimate']->validate();
        }
    }

    /**
     * Gets time_of_fees_estimation.
     */
    public function getTimeOfFeesEstimation() : \DateTimeInterface
    {
        return $this->container['time_of_fees_estimation'];
    }

    /**
     * Sets time_of_fees_estimation.
     *
     * @param \DateTimeInterface $time_of_fees_estimation The time at which the fees were estimated. This defaults to the time the request is made.
     */
    public function setTimeOfFeesEstimation(\DateTimeInterface $time_of_fees_estimation) : self
    {
        $this->container['time_of_fees_estimation'] = $time_of_fees_estimation;

        return $this;
    }

    /**
     * Gets total_fees_estimate.
     */
    public function getTotalFeesEstimate() : ?MoneyType
    {
        return $this->container['total_fees_estimate'];
    }

    /**
     * Sets total_fees_estimate.
     *
     * @param null|\AmazonPHP\SellingPartner\Model\ProductFees\MoneyType $total_fees_estimate total_fees_estimate
     */
    public function setTotalFeesEstimate(?MoneyType $total_fees_estimate) : self
    {
        $this->container['total_fees_estimate'] = $total_fees_estimate;

        return $this;
    }

    /**
     * Gets fee_detail_list.
     *
     * @return null|\AmazonPHP\SellingPartner\Model\ProductFees\FeeDetail[]
     */
    public function getFeeDetailList() : ?array
    {
        return $this->container['fee_detail_list'];
    }

    /**
     * Sets fee_detail_list.
     *
     * @param null|\AmazonPHP\SellingPartner\Model\ProductFees\FeeDetail[] $fee_detail_list a list of other fees that contribute to a given fee
     */
    public function setFeeDetailList(?array $fee_detail_list) : self
    {
        $this->container['fee_detail_list'] = $fee_detail_list;

        return $this;
    }

    /**
     * Returns true if offset exists. False otherwise.
     */
    public function offsetExists($offset) : bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @return null|mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset) : mixed
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     */
    public function offsetSet($offset, $value) : void
    {
        if (null === $offset) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     */
    public function offsetUnset($offset) : void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     *
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed returns data which can be serialized by json_encode(), which is a value
     *               of any type other than a resource
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize() : string
    {
        return \json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR);
    }

    /**
     * Gets a header-safe presentation of the object.
     */
    public function toHeaderValue() : string
    {
        return \json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR);
    }
}
